*! version 5.0
* 13 August 2018
* NIDS

* THIS IS A FOOD AND NON-FOOD EXPENDITURE DO FILE: 11 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Food_NonFood Expenditure - Master  Food_NonFood Expenditure do file  (1 of 14).do"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

use "$DataOUT\tempdata9.dta", clear

**********************************************************************
***			Final Release of Expenditure Data
**********************************************************************
*This file takes the more comprehensive version of the expenditure data generated by "aggshort.do" (which includes expenditure on each line item,
*dummy variables, and data for two different types of imputation) and reduces it down to only the aggregate expenditure data for food, non-food, and total
*expenditure. The regression method of imputation is used for the final expenditure release. 
*The end of this file merges the new expenditure data into the 
**********************************************************************

capture drop w1_h_expenditure w1_h_exprough w1_h_expnf w1_h_expf				//drops variables that are not needed
rename totalexpreg w1_h_expenditure	
label var w1_h_expenditure "Household Expenditure with full imputations"

rename totalexprough w1_h_exprough
label var w1_h_exprough "Household Expenditure without any imputations"

rename nfregagg w1_h_expnf
label var w1_h_expnf "Non-Food Expenditure with full imputations"

rename fregagg w1_h_expf
label var w1_h_expf "Food Expenditure with full imputations"

keep w1_hhid  w1_h_exprough w1_h_expnf w1_h_expf				//keeps only required variables

rename w1_h_exprough  w1_exprough
rename w1_h_expnf w1_expnf
rename w1_h_expf w1_expf

*Saves the new houshold derived data file to the output folder"
save "$DataOUT\hhderived_Expenditure_Food_NonFood.dta", replace
*---------------------------------------------------------------------------------------------------------------------------

*Erasing temporary datasets
erase "$DataOUT\tempdata.dta" 
forvalues x = 2/9 {
erase "$DataOUT\tempdata`x'.dta" 
}

*-------------------------------------------------------------------------------------------------------------------
